/*
 * Decompiled with CFR 0.152.
 */
package com.worldswanderer.acid;

import com.mojang.logging.LogUtils;
import com.worldswanderer.acid.setup.ModBlocks;
import com.worldswanderer.acid.setup.ModFluidTypes;
import com.worldswanderer.acid.setup.ModFluids;
import com.worldswanderer.acid.setup.ModItems;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="acid")
public class AcidMod {
    public static final String MODID = "acid";
    private static final Logger LOGGER = LogUtils.getLogger();

    public AcidMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModFluidTypes.FLUID_TYPES.register(bus);
        ModFluids.FLUIDS.register(bus);
        ModBlocks.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Acid mod common setup");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Acid mod client setup");
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.ACID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_ACID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.WEAK_ACID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_WEAK_ACID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SMALL_ACID_MUSHROOM.get()), (RenderType)RenderType.m_110463_());
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Server starting - Acid mod");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            event.accept(ModItems.SMALL_ACID_MUSHROOM_ITEM);
            event.accept(ModItems.ACID_MUSHROOM_BLOCK_ITEM);
            event.accept(ModItems.ACID_MUSHROOM_STEM_ITEM);
            event.accept(ModItems.ACIDIC_SEDIMENT_BLOCK_ITEM);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ModItems.ACID_BUCKET);
            event.accept(ModItems.WEAK_ACID_BUCKET);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            event.accept(ModItems.ACID_CONCENTRATE);
        }
    }
}

